************************************************************************************************
* Name			: table C1 - number of factors 
*
* Description	: This dofile performs the Vlicer's MAp rule and Horn's parallel analysis to 
*                 determine the number of factors in each group of variables 	
************************************************************************************************

********************************************************************************
* SETTINGS 
********************************************************************************
clear 				all 
set more 			off 
set graphics 		off 
version 			15          /*Use Stata 15*/ 
set seed			16072015   	/* This is the seed number that was used to create the bootstrapped samples for estimation of the model in the paper */ 

* Options for data to create 
global testerFE 	no 			/*Take out tester FE before standardizing measures*/ 
global invar 		no 			/*Incorporate intercepts in the measurement system for when we will allow for measurement system variance*/ 
global pure 		no 			/*Only pure control and pure stimulation groups*/ 

* Globals of directories, variable groups and others 
run "$dir_statacode\globals.do" 

* Dataset with standardized measures 
use "$dir_data\measures.dta", clear 


********************************************************************************
* Define groups of variables 
********************************************************************************
#delim; 

global efa_cfu 			b_tot_le1_st b_tot_mf1_st mac_words1_st mac_phrases1_st
						bates_unsociable1_st bates_difficult1_st
						bates_unadaptable1_st bates_unstoppable1_st
						roth_inhibit1_st roth_attention1_st roth_sociable1_st;
			
global efa_cba			b_tot_cog0_st b_tot_lr0_st b_tot_le0_st b_tot_mf0_st mac_words0_st mac_unders0_st
						bates_unsociable0_st bates_difficult0_st
						bates_unadaptable0_st bates_unstoppable0_st;

global efa_mba 			edu_yrs_mo0_st peabody_mo1_st  adult_books0_st adult_mags0_st raventot_st cesdA0_st
						cesdB0_st cesdC0_st cesdD0_st cesdE0_st cesdF0_st cesdG0_st cesdH0_st
						cesdI0_st cesdJ0_st; 
						
global efa_invest       fci_play_mat_type1_st Npicbooks1_st
						Npaintbooks1_st Ntoysmade1_st Ntoysbought1_st Nthingsmove1_st Ntoysshape1_st
						fci_play_act1_st home_stories1_st home_read1_st 
						home_toys1_st home_name1_st; 
						
#delim cr 						
********************************************************************************
* Test for number of factors 
********************************************************************************
cap log close 
log using "$dir_output/TableC1.log", replace 
foreach group in efa_cba efa_cfu efa_mba efa_invest{ 
minap $`group' 
paran $`group' 
} 
cap log close 


	